#ifndef __INC_AFFECT_H
#define __INC_AFFECT_H
#ifdef ENABLE_BIOLOGIST_UI
#include "../../common/length.h"
#endif
#ifdef ENABLE_SKILLS_BUFF_ALTERNATIVE
typedef struct SAffectSkills
{
		DWORD	dwType;
		BYTE	bApplyOn;
		long	lApplyValue;
		DWORD	dwFlag;
		long	lDuration;
		long	lSPCost;
		DWORD	dwTime;
} TAffectSkills;
#endif

class CAffect
{
	public:
		DWORD	dwType;
		BYTE    bApplyOn;
		long    lApplyValue;
		DWORD   dwFlag;
		long	lDuration;
		long	lSPCost;

		static CAffect* Acquire();
		static void Release(CAffect* p);
};

enum EAffectTypes
{
	AFFECT_NONE,
	AFFECT_MOV_SPEED = 200,
	AFFECT_ATT_SPEED,
	AFFECT_ATT_GRADE,
	AFFECT_INVISIBILITY,
	AFFECT_STR,
	AFFECT_DEX,
	AFFECT_CON,
	AFFECT_INT,
	AFFECT_FISH_MIND_PILL,
	AFFECT_POISON,
	AFFECT_STUN,
	AFFECT_SLOW,
	AFFECT_DUNGEON_READY,
	AFFECT_DUNGEON_UNIQUE, // unused
	AFFECT_BUILDING,
	AFFECT_REVIVE_INVISIBLE,
	AFFECT_FIRE,
	AFFECT_CAST_SPEED,
	AFFECT_HP_RECOVER_CONTINUE,
	AFFECT_SP_RECOVER_CONTINUE,
	AFFECT_POLYMORPH,
	AFFECT_MOUNT,
	AFFECT_WAR_FLAG,
	AFFECT_BLOCK_CHAT,
	AFFECT_CHINA_FIREWORK,
	AFFECT_BOW_DISTANCE,
	AFFECT_DEF_GRADE,
#ifdef ENABLE_WOLFMAN_CHARACTER
	AFFECT_BLEEDING,
#endif
#ifdef __NEWPET_SYSTEM__
	AFFECT_PET,
#endif
	AFFECT_RAMADAN_ABILITY = 300,
	AFFECT_RAMADAN_RING = 301,
	AFFECT_NOG_ABILITY = 302,
	AFFECT_HOLLY_STONE_POWER = 303,
#ifdef ENABLE_SOUL_SYSTEM
	AFFECT_SOUL_RED = 304,
	AFFECT_SOUL_BLUE = 305,
#endif
	AFFECT_PREMIUM_START = 500,
	AFFECT_EXP_BONUS = 500,
	AFFECT_ITEM_BONUS = 501,
	AFFECT_SAFEBOX = 502,
	AFFECT_AUTOLOOT = 503,
	AFFECT_FISH_MIND = 504,
	AFFECT_MARRIAGE_FAST = 505,
	AFFECT_GOLD_BONUS = 506,
	AFFECT_PREMIUM_END = 509,
	AFFECT_MALL = 510,
	AFFECT_NO_DEATH_PENALTY = 511,
	AFFECT_SKILL_BOOK_BONUS = 512,
	AFFECT_SKILL_NO_BOOK_DELAY = 513,
	AFFECT_HAIR	= 514,
	AFFECT_COLLECT = 515,
	AFFECT_EXP_BONUS_EURO_FREE = 516,
	AFFECT_EXP_BONUS_EURO_FREE_UNDER_15 = 517,
	AFFECT_UNIQUE_ABILITY = 518,
	AFFECT_CUBE_1,
	AFFECT_CUBE_2,
	AFFECT_CUBE_3,
	AFFECT_CUBE_4,
	AFFECT_CUBE_5,
	AFFECT_CUBE_6,
	AFFECT_CUBE_7,
	AFFECT_CUBE_8,
	AFFECT_CUBE_9,
	AFFECT_CUBE_10,
	AFFECT_CUBE_11,
	AFFECT_CUBE_12,
	AFFECT_BLEND,
	AFFECT_HORSE_NAME,
	AFFECT_MOUNT_BONUS,
	AFFECT_AUTO_HP_RECOVERY = 534,
	AFFECT_AUTO_SP_RECOVERY = 535,
#ifdef ENABLE_NEW_USE_POTION
	AFFECT_AUTO_HP_RECOVERY2 = 536,
	AFFECT_AUTO_SP_RECOVERY2 = 537,
#endif
#ifdef __NEWPET_SYSTEM__
	AFFECT_NEW_PET = 539,
#endif
	AFFECT_DRAGON_SOUL_QUALIFIED = 540,
	AFFECT_DRAGON_SOUL_DECK_0 = 541,
	AFFECT_DRAGON_SOUL_DECK_1 = 542,
#if defined(ENABLE_RECALL) && defined(ENABLE_SUPPORT_SYSTEM)
	AFFECT_RECALL3 = 543,
#endif
#ifdef ENABLE_DS_SET
	AFFECT_DS_SET = 563,
	AFFECT_DS_BNS1 = 564,
	AFFECT_DS_BNS2 = 565,
	AFFECT_DS_BNS3 = 566,
#endif
#ifdef ENABLE_NEW_USE_POTION
	AFFECT_NEW_POTION1 = 567,
	AFFECT_NEW_POTION2 = 568,
	AFFECT_NEW_POTION3 = 569,
	AFFECT_NEW_POTION4 = 570,
	AFFECT_NEW_POTION5 = 571,
	AFFECT_NEW_POTION6 = 572,
	AFFECT_NEW_POTION7 = 573,
	AFFECT_NEW_POTION8 = 574,
	AFFECT_NEW_POTION9 = 575,
	AFFECT_NEW_POTION10 = 576,
	AFFECT_NEW_POTION11 = 577,
	AFFECT_NEW_POTION12 = 578,
	AFFECT_NEW_POTION13 = 579,
	AFFECT_NEW_POTION14 = 580,
	AFFECT_NEW_POTION15 = 581,
	AFFECT_NEW_POTION16 = 582,
	AFFECT_NEW_POTION17 = 583,
	AFFECT_NEW_POTION18 = 584,
	AFFECT_NEW_POTION19 = 585,
	AFFECT_NEW_POTION20 = 586,
#endif
#ifdef ENABLE_RECALL
#ifdef __PET_SYSTEM__
	AFFECT_RECALL1 = 587,
#endif
#ifdef __NEWPET_SYSTEM__
	AFFECT_RECALL2 = 589,
#endif
#endif
#ifdef ENABLE_NEW_USE_POTION
	AFFECT_NEW_POTION21 = 590,
	AFFECT_NEW_POTION22 = 591,
	AFFECT_NEW_POTION23 = 592,
	AFFECT_NEW_POTION24 = 593,
	AFFECT_NEW_POTION25 = 594,
	AFFECT_NEW_POTION26 = 595,
	AFFECT_NEW_POTION27 = 596,
	AFFECT_NEW_POTION28 = 597,
	AFFECT_NEW_POTION29 = 598,
	AFFECT_NEW_POTION30 = 599,
	AFFECT_NEW_POTION31 = 600,
#endif
#ifdef ENABLE_BIOLOGIST_UI
	NEW_AFFECT_BIOLOGIST_1 = AFFECT_BIOLOGIST_1,
	NEW_AFFECT_BIOLOGIST_2 = AFFECT_BIOLOGIST_2,
	NEW_AFFECT_BIOLOGIST_3 = AFFECT_BIOLOGIST_3,
	NEW_AFFECT_BIOLOGIST_4 = AFFECT_BIOLOGIST_4,
	NEW_AFFECT_BIOLOGIST_5 = AFFECT_BIOLOGIST_5,
	NEW_AFFECT_BIOLOGIST_6 = AFFECT_BIOLOGIST_6,
	NEW_AFFECT_BIOLOGIST_7 = AFFECT_BIOLOGIST_7,
	NEW_AFFECT_BIOLOGIST_8 = AFFECT_BIOLOGIST_8,
	NEW_AFFECT_BIOLOGIST_9 = AFFECT_BIOLOGIST_9,
	NEW_AFFECT_BIOLOGIST_10 = AFFECT_BIOLOGIST_10,
	NEW_AFFECT_BIOLOGIST_11 = AFFECT_BIOLOGIST_11,
	NEW_AFFECT_BIOLOGIST_12 = AFFECT_BIOLOGIST_12,
	NEW_AFFECT_BIOLOGIST_13 = AFFECT_BIOLOGIST_13,
	NEW_AFFECT_BIOLOGIST_14 = AFFECT_BIOLOGIST_14,
#endif
#ifdef ENABLE_MELEY_LAIR
	AFFECT_STATUE = 700,
#endif
#ifdef ENABLE_CHOOSE_DOCTRINE_GUI
	AFFECT_PVM_RACE = 701,
#endif
#ifdef ENABLE_VOTE_FOR_BONUS
	AFFECT_VOTEFORBONUS = 702,
#endif
	AFFECT_FISH_BONUS = 995,
#ifdef ENABLE_RUNE_SYSTEM
	AFFECT_RUNE1 = 996,
	AFFECT_RUNE2,
#endif
#ifdef ENABLE_BLOCK_MULTIFARM
	AFFECT_DROP_BLOCK = 998,
	AFFECT_DROP_UNBLOCK,
#endif
	AFFECT_QUEST_START_IDX = 1000
};

enum EAffectBits
{
	AFF_NONE,

	AFF_YMIR,
	AFF_INVISIBILITY,
	AFF_SPAWN,

	AFF_POISON,
	AFF_SLOW,
	AFF_STUN,

	AFF_DUNGEON_READY,		//  غ 
	AFF_DUNGEON_UNIQUE,		//  ũ (Ŭ̾Ʈ ø)

	AFF_BUILDING_CONSTRUCTION_SMALL,
	AFF_BUILDING_CONSTRUCTION_LARGE,
	AFF_BUILDING_UPGRADE,

	AFF_MOV_SPEED_POTION,
	AFF_ATT_SPEED_POTION,

	AFF_FISH_MIND,

	AFF_JEONGWIHON,		// ȥ
	AFF_GEOMGYEONG,		// ˰
	AFF_CHEONGEUN,		// õ
	AFF_GYEONGGONG,		// 
	AFF_EUNHYUNG,		// 
	AFF_GWIGUM,			// Ͱ
	AFF_TERROR,			// 
	AFF_JUMAGAP,		// ָ
	AFF_HOSIN,			// ȣ
	AFF_BOHO,			// ȣ
	AFF_KWAESOK,		// 
	AFF_MANASHIELD,		// 
	AFF_MUYEONG,		//  affect
	AFF_REVIVE_INVISIBLE,	// Ȱ õ 
	AFF_FIRE,			//   
	AFF_GICHEON,		// õ
	AFF_JEUNGRYEOK,		// ¼
	AFF_TANHWAN_DASH,		// źȯݿ ޸Ʈ
	AFF_PABEOP,			// Ĺ
	AFF_CHEONGEUN_WITH_FALL,	// õ
	AFF_POLYMORPH,
	AFF_WAR_FLAG1,
	AFF_WAR_FLAG2,
	AFF_WAR_FLAG3,

	AFF_CHINA_FIREWORK,
	AFF_HAIR,	// 
	AFF_GERMANY, // 
	AFF_RAMADAN_RING,

#ifdef ENABLE_WOLFMAN_CHARACTER
	AFF_BLEEDING,			// 43
	AFF_RED_POSSESSION,		// 44
	AFF_BLUE_POSSESSION,	// 45
#endif


#ifdef ENABLE_MELEY_LAIR
	AFF_STATUE1 = 47,
	AFF_STATUE2,
	AFF_STATUE3,
	AFF_STATUE4,
#endif
#ifdef ENABLE_SOUL_SYSTEM
	AFF_SOUL_RED,
	AFF_SOUL_BLUE,
	AFF_SOUL_MIX,
#endif

	AFF_BITS_MAX
};

extern void SendAffectAddPacket(LPDESC d, CAffect * pkAff);

// AFFECT_DURATION_BUG_FIX
enum AffectVariable
{
	// Affect Ѵ  ־   .
	// ð  ̱  ſ ū Ѵ븦 ķ̼.
	//// 24Ʈ Ƿ 25Ʈ .
	// ... 25Ʈ Ѵٰ س 29bit ϰ ִ û ̶ּ...
	// collect quest  ð 60 ϰ Ƿ, ⵵ 60 .

	INFINITE_AFFECT_DURATION = 60 * 365 * 24 * 60 * 60
};
// END_AFFECT_DURATION_BUG_FIX

#endif
