#include "stdafx.h"

#include "questlua.h"
#include "questmanager.h"
#include "horsename_manager.h"
#include "char.h"
#include "affect.h"
#include "config.h"
#include "utils.h"
#include "db.h"

#include "New_PetSystem.h"

#undef sys_err
#ifndef __WIN32__
#define sys_err(fmt, args...) quest::CQuestManager::instance().QuestError(__FUNCTION__, __LINE__, fmt, ##args)
#else
#define sys_err(fmt, ...) quest::CQuestManager::instance().QuestError(__FUNCTION__, __LINE__, fmt, __VA_ARGS__)
#endif

extern int(*check_name) (const char * str);

namespace quest
{

#ifdef __NEWPET_SYSTEM__
	// syntax in LUA: pet.summon(mob_vnum, pet's name, (bool)run to me from far away)
	ALUA (newpet_summon)
	{
		LPCHARACTER ch = CQuestManager::instance().GetCurrentCharacterPtr();
		CNewPetSystem* petSystem = ch->GetNewPetSystem();
		LPITEM pItem = CQuestManager::instance().GetCurrentItem();
		if (!ch || !petSystem || !pItem)
		{
			lua_pushnumber(L, 0);
			return 1;
		}

#ifdef ENABLE_PVP_ADVANCED
		if ((ch->GetDuel("BlockPet")))
		{
#ifdef TEXTS_IMPROVEMENT
			ch->ChatPacketNew(CHAT_TYPE_INFO, 516, "");
#endif
			lua_pushnumber (L, 0);
			return 1;
		}
#endif

		if (0 == petSystem)
		{
			lua_pushnumber(L, 0);
			return 1;
		}

		// ȯ vnum
		DWORD mobVnum = lua_isnumber(L, 1) ? lua_tonumber(L, 1) : 0;

		// ȯ ̸		

		const char* petName = lua_isstring(L, 2) ? lua_tostring(L, 2) : 0;

		// ȯϸ ָ ޷ 
		bool bFromFar = lua_isboolean(L, 3) ? lua_toboolean(L, 3) : false;

		CNewPetActor* pet = petSystem->Summon(mobVnum, pItem, petName, bFromFar);

		if (pet != NULL)
			lua_pushnumber(L, pet->GetVID());
		else
			lua_pushnumber(L, 0);

		return 1;
	}

	// syntax: pet.unsummon(mob_vnum)
	ALUA (newpet_unsummon)
	{
		LPCHARACTER ch = CQuestManager::instance().GetCurrentCharacterPtr();
		if (!ch)
			return 0;
		
		CNewPetSystem* petSystem = ch->GetNewPetSystem();

		if (0 == petSystem)
			return 0;

		// ȯ vnum
		DWORD mobVnum = lua_isnumber(L, 1) ? lua_tonumber(L, 1) : 0;

		petSystem->Unsummon(mobVnum);
#ifdef ENABLE_RECALL
		const CAffect* pAffect = ch->FindAffect(AFFECT_RECALL2);
		if (pAffect) {
			ch->RemoveAffect(const_cast<CAffect*>(pAffect));
		}
#endif
		return 1;
	}

	// syntax: pet.unsummon(mob_vnum)
	ALUA (newpet_count_summoned)
	{
		LPCHARACTER ch = CQuestManager::instance().GetCurrentCharacterPtr();
		CNewPetSystem* petSystem = ch->GetNewPetSystem();

		lua_Number count = 0;

		if (0 != petSystem)
			count = (lua_Number)petSystem->CountSummoned();

		lua_pushnumber(L, count);

		return 1;
	}

	// syntax: pet.is_summon(mob_vnum)
	ALUA (newpet_is_summon)
	{
		LPCHARACTER ch = CQuestManager::instance().GetCurrentCharacterPtr();
		CNewPetSystem* petSystem = ch->GetNewPetSystem();

		if (0 == petSystem)
			return 0;

		// ȯ vnum
		DWORD mobVnum = lua_isnumber(L, 1) ? lua_tonumber(L, 1) : 0;

		CNewPetActor* petActor = petSystem->GetByVnum(mobVnum);

		if (NULL == petActor)
			lua_pushboolean(L, false);
		else
			lua_pushboolean(L, petActor->IsSummoned());

		return 1;
	}

	ALUA (newpet_increaseskill)
	{
		LPCHARACTER ch = CQuestManager::instance().GetCurrentCharacterPtr();
		CNewPetSystem* petSystem = ch->GetNewPetSystem();

		if (0 == petSystem)
			return 0;

		// ȯ vnum
#ifdef ENABLE_NEW_PET_EDITS
		lua_pushboolean(L, false);
#else
		DWORD skill = lua_isnumber(L, 1) ? lua_tonumber(L, 1) : 0;
		bool petActor = petSystem->IncreasePetSkill(skill);
		if (!petActor)
			lua_pushboolean(L, false);
		else
			lua_pushboolean(L, petActor);
#endif
		return 1;

	}

	ALUA (newpet_increaseevolution)
	{
		LPCHARACTER ch = CQuestManager::instance().GetCurrentCharacterPtr();
		CNewPetSystem* petSystem = ch->GetNewPetSystem();

		if (0 == petSystem)
			return 0;

		// ȯ vnum		

		bool petActor = petSystem->IncreasePetEvolution();

		if (!petActor)
			lua_pushboolean(L, false);
		else
			lua_pushboolean(L, petActor);
		return 1;

	}

	ALUA (newpet_get_level)
	{
		LPCHARACTER ch = CQuestManager::instance().GetCurrentCharacterPtr();
		CNewPetSystem* petSystem = ch->GetNewPetSystem();

		if (0 == petSystem) {
			lua_pushnumber(L, -1);
			return 0;
		}
		int pet_level = petSystem->GetLevel();

		if (pet_level == 0)
			lua_pushnumber(L, -1);
		else
			lua_pushnumber(L, pet_level);

		return 1;

	}

	ALUA (newpet_get_evo)
	{
		LPCHARACTER ch = CQuestManager::instance().GetCurrentCharacterPtr();
		CNewPetSystem* petSystem = ch->GetNewPetSystem();

		if (0 == petSystem) {
			lua_pushnumber(L, -1);
			return 0;
		}
		int pet_evo = petSystem->GetEvolution();

		if (0 == pet_evo)
			lua_pushnumber(L, -1);
		else
			lua_pushnumber(L, pet_evo);

		return 1;

	}

	ALUA (newpet_restore_pet)
	{

		DWORD id = lua_isnumber(L, 1) ? lua_tonumber(L, 1) : 0;
		if (id == 0){
			lua_pushboolean(L, false);
			return 0;
		}

		char szQuery1[1024];
		snprintf(szQuery1, sizeof(szQuery1), "SELECT duration,tduration FROM new_petsystem WHERE id = %u ", id);
		std::unique_ptr<SQLMsg> pmsg2(DBManager::instance().DirectQuery(szQuery1));
		if (pmsg2->Get()->uiNumRows > 0) {
			MYSQL_ROW row = mysql_fetch_row(pmsg2->Get()->pSQLResult);
			if (atoi(row[0]) <= 0){
				delete(DBManager::instance().DirectQuery("UPDATE new_petsystem SET duration=%d WHERE id = %lu ", atoi(row[1]), id));
				lua_pushboolean(L, true);
			}
			else{
				lua_pushboolean(L, false);
			}
		}
		else{
			lua_pushboolean(L, false);
		}

		return 1;
	}

	ALUA (newpet_spawn_effect)
	{
		LPCHARACTER ch = CQuestManager::instance().GetCurrentCharacterPtr();
		CNewPetSystem* petSystem = ch->GetNewPetSystem();

		if (0 == petSystem)
			return 0;

		DWORD mobVnum = lua_isnumber(L, 1) ? lua_tonumber(L, 1) : 0;

		CNewPetActor* petActor = petSystem->GetByVnum(mobVnum);
		if (NULL == petActor)
			return 0;
		LPCHARACTER pet_ch = petActor->GetCharacter();
		if (NULL == pet_ch)
			return 0;

		if (lua_isstring(L, 2))
		{
			pet_ch->SpecificEffectPacket(lua_tostring(L, 2));
		}
		return 0;
	}

	ALUA(newpet_eggrequest)
	{
		LPCHARACTER ch = CQuestManager::instance().GetCurrentCharacterPtr();		
		int evid = lua_isnumber(L, 0) ? lua_tonumber(L, 0) : 0;
		ch->SetEggVid(evid);
		return 1;
	}
	
#ifdef ENABLE_NEW_PET_EDITS
	ALUA(newpet_reset_skills)
	{
		LPCHARACTER ch = CQuestManager::instance().GetCurrentCharacterPtr();
		if (!ch) {
			lua_pushnumber(L, 2);
			return 1;
		}
		
		CNewPetSystem* petSystem = ch->GetNewPetSystem();
		if (!petSystem) {
			lua_pushnumber(L, 2);
			return 1;
		}
		
		lua_pushnumber(L, petSystem->ResetSkills());
		return 1;
	}
	
	ALUA(newpet_reset_skill)
	{
		LPCHARACTER ch = CQuestManager::instance().GetCurrentCharacterPtr();
		if (!ch) {
			lua_pushnumber(L, 2);
			return 1;
		}
		
		CNewPetSystem* petSystem = ch->GetNewPetSystem();
		if (!petSystem) {
			lua_pushnumber(L, 2);
			return 1;
		}
		
		int iType = lua_isnumber(L, 1) ? lua_tonumber(L, 1) : 0;
		lua_pushnumber(L, petSystem->ResetSkill(iType));
		return 1;
	}
#endif

	ALUA(newpet_change_name)
	{
		LPCHARACTER ch = CQuestManager::instance().GetCurrentCharacterPtr();
		if (!ch)
			return 0;

		if (lua_isstring(L, 1) != true) {
			lua_pushnumber(L, 0);
			return 1;
		}

		const char * szName = lua_tostring(L, 1);
		if (check_name(szName) == false) {
			lua_pushnumber(L, 0);
			return 1;
		}

		CNewPetSystem* petSystem = ch->GetNewPetSystem();
		if (!petSystem) {
			lua_pushnumber(L, 3);
			return 1;
		}

		char query1[256] = {0};
		snprintf(query1, sizeof(query1), "SELECT id FROM player.new_petsystem WHERE name='%s';", szName);
		std::unique_ptr<SQLMsg> pRes(DBManager::instance().DirectQuery(query1));
		if (pRes->Get()->uiNumRows > 0) {
			lua_pushnumber(L, 2);
			return 1;
		} else {
			petSystem->ChangeName(szName);
			lua_pushnumber(L, 1);
			return 1;
		}
	}

	void RegisterNewPetFunctionTable()
	{
		luaL_reg pet_functions[] =
		{
			{ "EggRequest",		newpet_eggrequest},
			{ "summon",			newpet_summon },
			{ "unsummon",		newpet_unsummon },
			{ "is_summon",		newpet_is_summon },
			{ "count_summoned",	newpet_count_summoned },
			{ "spawn_effect",	newpet_spawn_effect },
			{ "increaseskill",	newpet_increaseskill},
			{ "increaseevo",	newpet_increaseevolution},
			{ "getlevel",		newpet_get_level },
			{ "getevo",			newpet_get_evo },
			{ "restorepet",		newpet_restore_pet},
#ifdef ENABLE_NEW_PET_EDITS
			{"reset_skills", newpet_reset_skills},
			{"reset_skill", newpet_reset_skill},
#endif
			{"change_name", newpet_change_name},
			{ NULL,				NULL }
		};

		CQuestManager::instance().AddLuaFunctionTable("newpet", pet_functions);
	}
#endif

}